(function(exports) {
exports.access_commands = function() { return [
{"name": l100n.localize_string("access_control_on"), "command": "0x00010000"},
{"name": l100n.localize_string("access_control_off"), "command": "0x00020000"},
{"name": l100n.localize_string("access_level_reset"), "command": "0x00030000"},
{"name": l100n.localize_string("change_password"), "command": "0x00040000"},
//{"name": l100n.localize_string("counter_reset"), "command": "1991"},
//{"name": l100n.localize_string("download_settings"), "command": "0x00050000"},
//{"name": l100n.localize_string("upload_settings"), "command": "0x00060000"},
{"name": l100n.localize_string("reboot"), "command": "0x746f6f62"},
{"name": "", "command": "0"}
]}
exports.head_types_all = function() { return [
	{"name": "А - 230 V AC", "command": "1"},
	{"name": "D - 24 V DC", "command": "2"},
	{"name": "HC-12F A MB", "command": "193"},
	{"name": "HC-12F D MB", "command": "194"}
]}
exports.head_types = function() { return [
	{"name": "А - 230 V AC", "command": "1"},
	{"name": "D - 24 V DC", "command": "2"}
]}
exports.hc_12f_head_types = function() { return [
	{"name": "HC-12F A MB", "command": "193"},
	{"name": "HC-12F D MB", "command": "194"}
]}
exports.restart_reason = function() { return [
{"new_value": "Button \"Reset\"", "raw_value": "1"},
{"new_value": "WatchDog", "raw_value": "9"},
{"new_value": "PowerUp", "raw_value": "67"},
{"new_value": "Software", "raw_value": "5"}
]}
exports.module_types_all = function() { return [
	{"name": l100n.localize_string("dummy"), "command": "0"},
	{"name": "MCU - 1 - 10HDI", "command": "1"},
	{"name": "MCU - 2 - 10DI", "command": "2"},
	{"name": "MCU - 3 - 8AI", "command": "3"},
	{"name": "MCU - 4 - 8CTI", "command": "4"},
	{"name": "MCU - 5 - 4RTD (400Ω)", "command": "5"},
	{"name": "MCU - 5 - 4RTD (10kΩ)", "command": "19"},
	{"name": "MCU - 6 - 8VI", "command": "6"},
	{"name": "MCU - 7 - 2AO", "command": "7"},
	{"name": "MCU - 7 - 4AO", "command": "20"},
	{"name": "MCU - 8 - 4RO", "command": "8"},
	{"name": "MCU - 9 - 10HDO", "command": "9"},
	{"name": "MCU - 10 - MDR-I/O-1", "command": "10"},
	{"name": "MCU - F", "command": "13"},
	{"name": "MCU - F", "command": "14"},
	{"name": "H - EM", "command": "16"},
	{"name": "L - EM", "command": "17"},
	{"name": "MCU - 18 - MDR-I/O-3", "command": "18"},
	{"name": "HC-12F 12CTI", "command": "64"},
	{"name": "HC-12F 6HDO16DI", "command": "160"},
	{"name": l100n.localize_string("slot_absent"), "command": "255"}
]}
exports.module_types = function() { return [
{"name": l100n.localize_string("dummy"), "command": "0"},
{"name": "MCU - 1 - 10HDI", "command": "1"},
{"name": "MCU - 2 - 10DI", "command": "2"},
{"name": "MCU - 3 - 8AI", "command": "3"},
{"name": "MCU - 4 - 8CTI", "command": "4"},
{"name": "MCU - 5 - 4RTD (400Ω)", "command": "5"},
{"name": "MCU - 5 - 4RTD (10kΩ)", "command": "19"},
{"name": "MCU - 6 - 8VI", "command": "6"},
{"name": "MCU - 7 - 2AO", "command": "7"},
{"name": "MCU - 7 - 4AO", "command": "20"},
{"name": "MCU - 8 - 4RO", "command": "8"},
{"name": "MCU - 9 - 10HDO", "command": "9"},
{"name": "MCU - 10 - MDR-I/O-1", "command": "10"},
{"name": "MCU - F", "command": "13"},
{"name": "MCU - F", "command": "14"},
{"name": "H - EM", "command": "16"},
{"name": "L - EM", "command": "17"},
{"name": "MCU - 18 - MDR-I/O-3", "command": "18"},
{"name": l100n.localize_string("slot_absent"), "command": "255"}
]}
exports.hc_12f_module_types = function() { return [
	{"name": l100n.localize_string("dummy"), "command": "0"},
	{"name": "HC-12F 12CTI", "command": "64"},
	{"name": "HC-12F 6HDO16DI", "command": "160"},
	{"name": l100n.localize_string("slot_absent"), "command": "255"}
]}
exports.connection_scheme = function() { return [
{"name": "4LN3", "command": "0"},
{"name": "4LL3/3LL3", "command": "8"},
{"name": "4LN2", "command": "1"},
{"name": "3LN3", "command": "4"},
{"name": "3LN2", "command": "5"},
{"name": "3LL2", "command": "9"},
{"name": "3OP3", "command": "2"},
{"name": "3OP2", "command": "3"}
]}
exports.current_range = function() { return [
{"name": l100n.localize_string("H-5A/L-0,1A"), "command": "1"},
{"name": l100n.localize_string("H-1,25A/L-0,025A"), "command": "4"}
]}
exports.current_diff_range = function() { return [
	{"name": l100n.localize_string("500µA"), "command": "1"},
	{"name": l100n.localize_string("125µA"), "command": "4"}
]}
exports.access_values = function() { return [
{"new_value": l100n.localize_string("off"), "raw_value": "0"},
{"new_value": l100n.localize_string("user"), "raw_value": "1"},
{"new_value": l100n.localize_string("admin"), "raw_value": "2"}
]}
exports.default_checkbox_values = function() { return [
{"new_value": l100n.localize_string("off"), "raw_value": "0"},
{"new_value": l100n.localize_string("on"), "raw_value": "1"}
]}
exports.on_off_values = function() { return [
{"name": l100n.localize_string("off"), "command": "0"},
{"name": l100n.localize_string("on"), "command": "1"}
]}
exports.yes_no_values = function() { return [
{"name": l100n.localize_string("no"), "command": "0"},
{"name": l100n.localize_string("yes"), "command": "1"}
]}
exports.baudrate = function() { return [
{"name": l100n.localize_string("9.6"), "command": "9600"},
{"name": l100n.localize_string("19.2"), "command": "19200"},
{"name": l100n.localize_string("38.4"), "command": "38400"},
{"name": l100n.localize_string("57.6"), "command": "57600"},
{"name": l100n.localize_string("115.2"), "command": "115200"}
]}
exports.CAN_speed = function() { return [
{"name": "50", "command": "50000"},
{"name": "100", "command": "100000"},
{"name": "125", "command": "125000"},
{"name": "250", "command": "250000"},
{"name": "500", "command": "500000"},
{"name": "800", "command": "800000"},
{"name": "1000", "command": "1000000"}
]}
exports.CAN_port_status = function() { return [
{"new_value": "No error", "raw_value": "0"},
{"new_value": "Protocol Warning (1)", "raw_value": "1"},
{"new_value": "Protocol Warning. Passive (3)", "raw_value": "3"},
{"new_value": "Form error (19)", "raw_value": "19"},
{"new_value": "Form error. Bus-off. Passive. Protocol Warning (23)", "raw_value": "23"},
{"new_value": "Acknowledgment (35)", "raw_value": "35"},
{"new_value": "Bit recessive (64)", "raw_value": "64"},
{"new_value": "Bit recessive. Passive. Protocol Warning (67)", "raw_value": "67"},
{"new_value": "Bit dominant (128)", "raw_value": "128"},
{"new_value": "Bit dominant. Protocol Warning (129)", "raw_value": "129"},
{"new_value": "Bit dominant. Protocol Warning. Passive (131)", "raw_value": "131"},
{"new_value": "Bus-off. Bit dominant. Protocol Warning (133)", "raw_value": "133"},
{"new_value": "Bus-off. Bit dominant. Passive. Protocol Warning (135)", "raw_value": "135"},
]}
exports.canopen_node_status = function() { return [
{"new_value": "No Active", "raw_value": "0"},
{"new_value": "Active", "raw_value": "1"},
]}
exports.canopen_NMT_status = function() { return [
{"new_value": "Initialisation", "raw_value": "0"},
{"new_value": "Disconnected", "raw_value": "1"},
{"new_value": "Connecting", "raw_value": "2"},
//		{"new_value": "Preparing", "raw_value": "2"},
{"new_value": "Stopped", "raw_value": "4"},
{"new_value": "Operational", "raw_value": "5"},
{"new_value": "Pre operational", "raw_value": "127"},
{"new_value": "Not configured", "raw_value": "15"},
]}
exports.parity = function() { return [
{"name": l100n.localize_string("off"), "command": "0"},
{"name": l100n.localize_string("even"), "command": "1"},
{"name": l100n.localize_string("odd"), "command": "2"}
]}
exports.stopbits = function() { return [
{"name": "1", "command": "1"},
{"name": "2", "command": "2"}
]}
exports.report_flag = function() { return [
{"name": l100n.localize_string("REPORT_FLAG_OK"), "command": "0x80000000"},
{"name": l100n.localize_string("REPORT_FLAG_NOT_FULL"), "command": "0x40000000"},
{"name": l100n.localize_string("REPORT_FLAG_ENERGY_CLEANED"), "command": "0x20000000"},
{"name": l100n.localize_string("REPORT_FLAG_TIME_SHIFT_FORWARD"), "command": "0x10000000"},
{"name": l100n.localize_string("REPORT_FLAG_TIME_SHIFT_BACKWARD"), "command": "0x08000000"},
{"name": l100n.localize_string("REPORT_FLAG_TIME_CHANGED"), "command": "0x04000000"},
{"name": l100n.localize_string("REPORT_FLAG_PREVIUOS_REPORT"), "command": "0x02000000"},
]}
exports.hw_error_flags = function() { return [
{"new_value": l100n.localize_string("NO_ERROR"), "bit_position": 0},
{"new_value": l100n.localize_string("HW_ERROR_NO_MAINS_POWER"), "bit_position": 1},
{"new_value": l100n.localize_string("HW_ERROR_FLASH"), "bit_position": 2},
{"new_value": l100n.localize_string("HW_ERROR_CRITICAL_STORAGE"), "bit_position": 3},
{"new_value": l100n.localize_string("HW_ERROR_EXT_RAM"), "bit_position": 4},
{"new_value": l100n.localize_string("HW_ERROR_UNSPECIFIED"), "bit_position": 5},
{"new_value": l100n.localize_string("HW_ERROR_BATTERY"), "bit_position": 6},
{"new_value": l100n.localize_string("HW_ERROR_RTC"), "bit_position": 7},
{"new_value": l100n.localize_string("HW_ERROR_COMM"), "bit_position": 8},
{"new_value": l100n.localize_string("HW_ERROR_MODULE_1"), "bit_position": 9},
{"new_value": l100n.localize_string("HW_ERROR_MODULE_2"), "bit_position": 10},
{"new_value": l100n.localize_string("HW_ERROR_MODULE_3"), "bit_position": 11},
{"new_value": l100n.localize_string("HW_ERROR_MODULE_4"), "bit_position": 12},
{"new_value": l100n.localize_string("HW_ERROR_MODULE_5"), "bit_position": 13},
{"new_value": l100n.localize_string("HW_ERROR_MODULE_6"), "bit_position": 14},
{"new_value": l100n.localize_string("HW_ERROR_MODULE_7"), "bit_position": 15},
{"new_value": l100n.localize_string("HW_ERROR_MODULE_8"), "bit_position": 16},
]}
exports.sw_error_flags = function() { return [
{"new_value": l100n.localize_string("NO_ERROR"), "bit_position": 0},
{"new_value": l100n.localize_string("SW_ERROR_NEED_RESTART"), "bit_position": 1},
{"new_value": l100n.localize_string("SW_ERROR_FS"), "bit_position": 2},
{"new_value": l100n.localize_string("SW_ERROR_RAM"), "bit_position": 3},
{"new_value": l100n.localize_string("SW_ERROR_RESCUE_FROM_FAILURE"), "bit_position": 4},
{"new_value": l100n.localize_string("SW_ERROR_EXCEPTION"), "bit_position": 5},
{"new_value": l100n.localize_string("SW_ERROR_INCOMTATIBLE_SETTINGS"), "bit_position": 6},
{"new_value": l100n.localize_string("SW_ERROR_TIME"), "bit_position": 7},
{"new_value": l100n.localize_string("SW_ERROR_APPLICATION"), "bit_position": 8},
]}
// Modbus client
exports.mb_functions = function() { return [
{"name": l100n.localize_string("not selected"), "command": "0"},
{"name": "3 - Read Holding Registers",    "command": "3"},
{"name": "4 - Read Input Registers",      "command": "4"},
{"name": "6 - Write Single Register",     "command": "6"},
{"name": "16 - Write Multiple Registers", "command": "16"}
]}
exports.byte_and_word_order = function() { return [
{"new_value": "Do not change", "raw_value": "0"},
//{"name":"Do not change","command":"0"},
//{"name":"Byte Swap","command":"1"}
]}
exports.req_trigger_type = function() { return [
{"name": l100n.localize_string("not selected"), "command": "0"},
{"name": "Polling", "command": "1"},
{"name": "Rising Edge", "command": "2"},
{"name": "Polling and Rising Edge", "command": "3"},
]}
exports.request_status = function() { return [
{"new_value": "Not enabled", "raw_value":        "0"},
{"new_value": "Misconfiguration", "raw_value":   "40960"},
{"new_value": "Active and Enabled", "raw_value": "49152"},
]}
exports.data_status = function() { return [
{"new_value": "Good Data", "raw_value": "0"},
{"new_value": "Bad data", "raw_value": "32768"},
{"new_value": "Bad data. Data Overriden", "raw_value": "32832"},
{"new_value": "Bad data. Timeout", "raw_value": "32784"},
{"new_value": "Bad data. Timeout. Data Overriden", "raw_value": "32848"},
{"new_value": "Bad data. Frame Error", "raw_value": "32800"},
{"new_value": "Bad data. Frame Error. Data Overriden", "raw_value": "32864"},
// exception
{"new_value": "Bad data. Exception code: Illegal function (1) ", "raw_value": "32769"},
{"new_value": "Bad data. Exception code: Illegal data address (2) ", "raw_value": "32770"},
{"new_value": "Bad data. Exception code: Illegal data value (3) ", "raw_value": "32771"},
{"new_value": "Bad data. Exception code: Slave device failure (4) ", "raw_value": "32772"},
{"new_value": "Bad data. Exception code: Acknowledge (5) ", "raw_value": "32773"},
{"new_value": "Bad data. Exception code: Slave busy (6) ", "raw_value": "32774"},
{"new_value": "Bad data. Exception code: Negative acknowledge (7) ", "raw_value": "32775"},
{"new_value": "Bad data. Exception code: Memory parity error (8) ", "raw_value": "32776"},
{"new_value": "Bad data. Exception code: Gateway path failed (10) ", "raw_value": "32778"},
{"new_value": "Bad data. Exception code: Gateway target failed (11) ", "raw_value": "32779"},
]}
//HCR
exports.line_mode = function() { return [
{"name": l100n.localize_string("Heater Off"), "command": "0"},
{"name": l100n.localize_string("Heater On"), "command": "1"},
{"name": l100n.localize_string("Remote"), "command": "2"},
{"name": l100n.localize_string("PWM"), "command": "3"},
{"name": l100n.localize_string("Temp Relay"), "command": "4"},
{"name": l100n.localize_string("PWM Proportional"), "command": "5"},
{"name": l100n.localize_string("Cable Current"), "command": "6"},
]}
exports.line_mode_rmo = function() { return [
{"name": l100n.localize_string("Heater Off"), "command": "0"},
{"name": l100n.localize_string("Heater On"), "command": "1"},
{"name": l100n.localize_string("PWM"), "command": "3"},
{"name": l100n.localize_string("Temp Relay"), "command": "4"},
{"name": l100n.localize_string("PWM Proportional"), "command": "5"},
]}
exports.line_mode_mdr = function() { return [
{"name": l100n.localize_string("Heater Off"), "command": "0"},
{"name": l100n.localize_string("Heater On"), "command": "1"},
{"name": l100n.localize_string("Remote"), "command": "2"},
{"name": l100n.localize_string("PWM"), "command": "3"},
{"name": l100n.localize_string("Temp Relay"), "command": "4"},
{"name": l100n.localize_string("PWM Proportional"), "command": "5"},
]}
exports.line_mode_status = function() { return [
{"new_value": l100n.localize_string("Heater Off"), "raw_value": "0"},
{"new_value": l100n.localize_string("Heater On"), "raw_value": "1"},
{"new_value": l100n.localize_string("Remote"), "raw_value": "2"},
{"new_value": l100n.localize_string("PWM"), "raw_value": "3"},
{"new_value": l100n.localize_string("Temp Relay"), "raw_value": "4"},
{"new_value": l100n.localize_string("PWM Proportional"), "raw_value": "5"},
{"new_value": l100n.localize_string("Cable Current"), "raw_value": "6"},
{"new_value": l100n.localize_string("error_status"), "raw_value": "255"},
]}
exports.line_mode_hcr03 = function() { return [
{"name": l100n.localize_string("Heater Off"), "command": "0"},
{"name": l100n.localize_string("Heater On"), "command": "1"},
{"name": l100n.localize_string("Remote"), "command": "2"},
{"name": l100n.localize_string("PWM"), "command": "3"},
{"name": l100n.localize_string("Temp Relay"), "command": "4"},
{"name": l100n.localize_string("PWM Proportional"), "command": "5"},
{"name": l100n.localize_string("Slave(Master L1)"), "command": "129"},
]}
exports.line_mode_status_hcr03 = function() { return [
{"new_value": l100n.localize_string("Heater Off"), "raw_value": "0"},
{"new_value": l100n.localize_string("Heater On"), "raw_value": "1"},
{"new_value": l100n.localize_string("Remote"), "raw_value": "2"},
{"new_value": l100n.localize_string("PWM"), "raw_value": "3"},
{"new_value": l100n.localize_string("Temp Relay"), "raw_value": "4"},
{"new_value": l100n.localize_string("PWM Proportional"), "raw_value": "5"},
{"new_value": l100n.localize_string("Slave(Master L1)"), "raw_value": "129"},
{"new_value": l100n.localize_string("error_status"), "raw_value": "255"},
]}
exports.temperature_mode = function() { return [
{"name": l100n.localize_string("off"), "command": "0"},
{"name": l100n.localize_string("First"), "command": "1"},
{"name": l100n.localize_string("Second"), "command": "2"},
{"name": l100n.localize_string("Average"), "command": "3"},
{"name": l100n.localize_string("Min"), "command": "4"},
{"name": l100n.localize_string("Max"), "command": "5"},
]}
exports.temperature_mode_rmo = function() { return [
{"name": l100n.localize_string("off"), "command": "0"},
{"name": l100n.localize_string("First"), "command": "1"},
]}
exports.sensors_number = function() {
	var sensors_number = [
		{"name": l100n.localize_string("off"), "command": "0"},
		{"name": `${l100n.localize_string("channel")} 1`, "command": "1"},
		{"name": `${l100n.localize_string("channel")} 2`, "command": "2"},
	]
	for(var ext_channel = 1; ext_channel < 17; ext_channel++) {
		sensors_number.push({"name": `${l100n.localize_string("channel")} 1-Wire ${ext_channel}`, "command": `${ext_channel+2}`})
	}
	return sensors_number
}
exports.sensors_number_rmo = function() {
	var sensors_number = [
		{"name": l100n.localize_string("off"), "command": "0"},
		{"name": `${l100n.localize_string("channel")} 1`, "command": "1"},
		{"name": `${l100n.localize_string("channel")} 2`, "command": "2"},
	]
	return sensors_number
}
exports.sensors_number_hcr_03 = function() {
	var sensors_number = [
		{"name": l100n.localize_string("off"), "command": "0"},
		{"name": `${l100n.localize_string("channel")} 1`, "command": "1"},
		{"name": `${l100n.localize_string("channel")} 2`, "command": "2"},
		{"name": `${l100n.localize_string("channel")} 3`, "command": "3"},
	]
	return sensors_number
}
exports.sensors_number_hcr_06 = function() {
	var sensors_number = [
		{"name": l100n.localize_string("off"), "command": "0"},
	]
	for(var ext_channel = 1; ext_channel < 17; ext_channel++) {
		sensors_number.push({"name": `${l100n.localize_string("channel")} 1-Wire ${ext_channel}`, "command": `${ext_channel}`})
	}
	return sensors_number
}
exports.sensors_number_mdr = function() { return [
{"name": l100n.localize_string("off"), "command": "0"},
{"name": "RTD 1", "command": "1"},
{"name": "RTD 2", "command": "2"},
{"name": "4-20mA 1", "command": "3"},
{"name": "4-20mA 2", "command": "4"},
]}
exports.sensor_type_all = function() { return [
{"name": l100n.localize_string("not selected"), "command": "0"},
{"name": l100n.localize_string("SENSOR_RTD_CU_50_426"),"command": "1"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_385"),"command": "2"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_385"),"command": "3"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_391"),"command": "4"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_391"),"command": "5"},
{"name": l100n.localize_string("SENSOR_RTD_CU_100_426"),"command": "6"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_385"),"command": "7"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_391"),"command": "8"},
{"name": l100n.localize_string("SENSOR_RTD_NI_100"),"command": "9"},
{"name": l100n.localize_string("SENSOR_RTD_OHMS_1"),"command":"10"},
{"name": l100n.localize_string("SENSOR_RTD_OHMS_2"),"command":"11"},
{"name": l100n.localize_string("SENSOR_RTD_CU_50_428"),"command": "12"},
{"name": l100n.localize_string("SENSOR_RTD_CU_100_428"),"command": "13"},
{"name": l100n.localize_string("SENSOR_NAMUR_DI"),"command": "14"},
{"name": l100n.localize_string("SENSOR_INNER_KTY"),"command": "15"},
{"name": l100n.localize_string("SENSOR_TC_R"),"command": "101"},
{"name": l100n.localize_string("SENSOR_TC_S"),"command": "102"},
{"name": l100n.localize_string("SENSOR_TC_B"),"command": "103"},
{"name": l100n.localize_string("SENSOR_TC_J"),"command": "104"},
{"name": l100n.localize_string("SENSOR_TC_T"),"command": "105"},
{"name": l100n.localize_string("SENSOR_TC_K"),"command": "106"},
{"name": l100n.localize_string("SENSOR_TC_N"),"command": "107"},
{"name": l100n.localize_string("SENSOR_TC_A1"),"command": "108"},
{"name": l100n.localize_string("SENSOR_TC_A2"),"command": "109"},
{"name": l100n.localize_string("SENSOR_TC_A3"),"command": "110"},
{"name": l100n.localize_string("SENSOR_TC_L"),"command": "111"},
{"name": l100n.localize_string("SENSOR_TC_VOLTS_1"),"command": "112"},
{"name": l100n.localize_string("SENSOR_TC_VOLTS_2"),"command": "113"},
{"name": l100n.localize_string("SENSOR_TC_E"),"command": "114"},
{"name": l100n.localize_string("SENSOR_TC_M"),"command": "115"},
{"name": l100n.localize_string("SENSOR_CL_4_20"),"command": "200"},
{"name": l100n.localize_string("SENSOR_CL_0_20"),"command": "201"},
]}
exports.sensor_type_rtd = function() { return [
//{"name": l100n.localize_string("not selected"), "command": "0"},
//{"name": l100n.localize_string("SENSOR_RTD_CU_50_426"), "command": "1"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_385"), "command": "2"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_385"), "command": "3"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_391"), "command": "4"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_391"), "command": "5"},
//{"name": l100n.localize_string("SENSOR_RTD_CU_100_426"),"command": "6"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_385"),"command": "7"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_391"),"command": "8"},
{"name": l100n.localize_string("SENSOR_RTD_NI_100"),"command": "9"},
]}
exports.sensor_type_ai = function() { return [
{"name": "0 - 20", "command": "201"},
{"name": "4 - 20", "command": "200"},
]}
exports.sensor_type_ti = function() { return [
//{"name": l100n.localize_string("not selected"), "command": "0"},
{"name": l100n.localize_string("SENSOR_RTD_CU_50_426"),"command": "1"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_385"),"command": "2"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_385"),"command": "3"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_391"),"command": "4"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_391"),"command": "5"},
{"name": l100n.localize_string("SENSOR_RTD_CU_100_426"),"command": "6"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_385"),"command": "7"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_391"),"command": "8"},
{"name": l100n.localize_string("SENSOR_RTD_NI_100"),"command": "9"},
{"name": l100n.localize_string("SENSOR_RTD_OHMS_1"),"command":"10"},
{"name": l100n.localize_string("SENSOR_RTD_OHMS_2"),"command":"11"},
{"name": l100n.localize_string("SENSOR_RTD_CU_50_428"),"command": "12"},
{"name": l100n.localize_string("SENSOR_RTD_CU_100_428"),"command": "13"},
{"name": l100n.localize_string("SENSOR_TC_R"),"command": "101"},
{"name": l100n.localize_string("SENSOR_TC_S"),"command": "102"},
{"name": l100n.localize_string("SENSOR_TC_B"),"command": "103"},
{"name": l100n.localize_string("SENSOR_TC_J"),"command": "104"},
{"name": l100n.localize_string("SENSOR_TC_T"),"command": "105"},
{"name": l100n.localize_string("SENSOR_TC_K"),"command": "106"},
{"name": l100n.localize_string("SENSOR_TC_N"),"command": "107"},
{"name": l100n.localize_string("SENSOR_TC_A1"),"command": "108"},
{"name": l100n.localize_string("SENSOR_TC_A2"),"command": "109"},
{"name": l100n.localize_string("SENSOR_TC_A3"),"command": "110"},
{"name": l100n.localize_string("SENSOR_TC_L"),"command": "111"},
{"name": l100n.localize_string("SENSOR_TC_VOLTS_1"),"command": "112"},
{"name": l100n.localize_string("SENSOR_TC_VOLTS_2"),"command": "113"},
{"name": l100n.localize_string("SENSOR_TC_E"),"command": "114"},
{"name": l100n.localize_string("SENSOR_TC_M"),"command": "115"},
]}
exports.sensor_type_2 = function() { return [
{"name": l100n.localize_string("not selected"), "command": "0"},
{"name": l100n.localize_string("SENSOR_RTD_CU_50_426"), "command": "1"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_385"), "command": "2"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_385"), "command": "3"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_391"), "command": "4"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_391"), "command": "5"},
{"name": l100n.localize_string("SENSOR_RTD_CU_100_426"), "command": "6"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_385"), "command": "7"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_391"), "command": "8"},
{"name": l100n.localize_string("SENSOR_RTD_NI_100"), "command": "9"},
{"name": l100n.localize_string("SENSOR_TC_R"),"command": "101"},
{"name": l100n.localize_string("SENSOR_TC_S"),"command": "102"},
{"name": l100n.localize_string("SENSOR_TC_B"),"command": "103"},
{"name": l100n.localize_string("SENSOR_TC_J"),"command": "104"},
{"name": l100n.localize_string("SENSOR_TC_T"),"command": "105"},
{"name": l100n.localize_string("SENSOR_TC_K"),"command": "106"},
{"name": l100n.localize_string("SENSOR_TC_N"),"command": "107"},
{"name": l100n.localize_string("SENSOR_TC_A1"),"command": "108"},
{"name": l100n.localize_string("SENSOR_TC_A2"),"command": "109"},
{"name": l100n.localize_string("SENSOR_TC_A3"),"command": "110"},
{"name": l100n.localize_string("SENSOR_TC_L"),"command": "111"},
{"name": l100n.localize_string("SENSOR_TC_E"),"command": "114"},
{"name": l100n.localize_string("SENSOR_TC_M"),"command": "115"},
]}
exports.sensor_type_mtu = function() { return [
{"name": l100n.localize_string("not selected"), "command": "0"},
{"name": l100n.localize_string("SENSOR_RTD_CU_50_426"),"command": "1"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_385"),"command": "2"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_385"),"command": "3"},
{"name": l100n.localize_string("SENSOR_RTD_PT_50_391"),"command": "4"},
{"name": l100n.localize_string("SENSOR_RTD_PT_100_391"),"command": "5"},
{"name": l100n.localize_string("SENSOR_RTD_CU_100_426"),"command": "6"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_385"),"command": "7"},
{"name": l100n.localize_string("SENSOR_RTD_PT_1000_391"),"command": "8"},
{"name": l100n.localize_string("SENSOR_RTD_NI_100"),"command": "9"},
{"name": l100n.localize_string("SENSOR_RTD_OHMS_1"),"command":"10"},
{"name": l100n.localize_string("SENSOR_RTD_OHMS_2"),"command":"11"},
{"name": l100n.localize_string("SENSOR_RTD_CU_50_428"),"command": "12"},
{"name": l100n.localize_string("SENSOR_RTD_CU_100_428"),"command": "13"},
{"name": l100n.localize_string("SENSOR_NAMUR_DI"),"command": "14"},
{"name": l100n.localize_string("SENSOR_INNER_KTY"),"command": "15"},
{"name": l100n.localize_string("SENSOR_TC_R"),"command": "101"},
{"name": l100n.localize_string("SENSOR_TC_S"),"command": "102"},
{"name": l100n.localize_string("SENSOR_TC_B"),"command": "103"},
{"name": l100n.localize_string("SENSOR_TC_J"),"command": "104"},
{"name": l100n.localize_string("SENSOR_TC_T"),"command": "105"},
{"name": l100n.localize_string("SENSOR_TC_K"),"command": "106"},
{"name": l100n.localize_string("SENSOR_TC_N"),"command": "107"},
{"name": l100n.localize_string("SENSOR_TC_A1"),"command": "108"},
{"name": l100n.localize_string("SENSOR_TC_A2"),"command": "109"},
{"name": l100n.localize_string("SENSOR_TC_A3"),"command": "110"},
{"name": l100n.localize_string("SENSOR_TC_L"),"command": "111"},
{"name": l100n.localize_string("SENSOR_TC_VOLTS_1"),"command": "112"},
{"name": l100n.localize_string("SENSOR_TC_VOLTS_2"),"command": "113"},
{"name": l100n.localize_string("SENSOR_TC_E"),"command": "114"},
{"name": l100n.localize_string("SENSOR_TC_M"),"command": "115"},
//{"name": l100n.localize_string("SENSOR_CL_4_20"),"command": "200"},
//{"name": l100n.localize_string("SENSOR_CL_0_20"),"command": "201"},
]}
exports.do_selector = function() { return [
{"name": l100n.localize_string("off"), "command": "0"},
{"name": "DO1", "command": "1"},
{"name": "DO2", "command": "2"},
{"name": "DO1+DO2", "command": "3"},
]}
exports.ai_selector = function() { return [
{"name": l100n.localize_string("off"), "command": "0"},
{"name": "CTI 1", "command": "1"},
{"name": "CTI 2", "command": "2"},
]}
exports.di_selector = function() { return [
{"name": l100n.localize_string("off"), "command": "0"},
{"name": "DI 1", "command": "1"},
{"name": "DI 2", "command": "2"},
{"name": "DI 3", "command": "3"},
{"name": "DI 4", "command": "4"},
{"name": "DI 5", "command": "5"},
]}
exports.di_status = function() { return [
{"new_value": l100n.localize_string("CHANNEL_OK"), "bit_position": 0},
{"new_value": l100n.localize_string("CHANNEL_FAULT"), "bit_position": 1},
{"new_value": l100n.localize_string("CHANNEL_LOW_FAILURE"), "bit_position": 2},
{"new_value": l100n.localize_string("CHANNEL_LOW"), "bit_position": 3},
{"new_value": l100n.localize_string("CHANNEL_HIGH"), "bit_position": 4},
{"new_value": l100n.localize_string("CHANNEL_HIGH_FAILURE"), "bit_position": 5},
{"new_value": l100n.localize_string("CHANNEL_NC"), "bit_position": 6},
{"new_value": l100n.localize_string("CHANNEL_SHORT_CIRCUIT"), "bit_position": 7}
]}
exports.emergency_mode = function() { return [
{"name": l100n.localize_string("Heater Off"), "command": "0"},
{"name": l100n.localize_string("Heater On"), "command": "1"},
{"name": l100n.localize_string("PWM"), "command": "3"},
]}
exports.line_command = function() { return [
{"name": l100n.localize_string("Trip Reset"), "command": "0x1FF"},
{"name": l100n.localize_string("Running Hours Reset"), "command": "0x2FF"},
{"name": l100n.localize_string("Switch On Counter Reset"), "command": "0x03FF"},
]}
exports.user_app_status = function() { return [
{"new_value": l100n.localize_string("ua_absent"), "raw_value": "0"},
{"new_value": l100n.localize_string("ua_running"), "raw_value": "1"},
{"new_value": l100n.localize_string("ua_stopped"), "raw_value": "2"},
{"new_value": l100n.localize_string("ua_stopped_error"), "raw_value": "16"},
{"new_value": l100n.localize_string("ua_no_program"), "raw_value": "255"},
]}
exports.appsw_cmd = function() { return [
{"name": l100n.localize_string("ua_start"), "command": "1"},
{"name": l100n.localize_string("ua_stop"), "command": "2"},
]}
exports.current_trip_mode = function() { return [
{"name": l100n.localize_string("Trip Off"), "command": "0"},
{"name": l100n.localize_string("Trip On"), "command": "1"},
]}
exports.temp_trip_mode = function() { return [
{"name": l100n.localize_string("Trip Off"), "command": "0"},
{"name": l100n.localize_string("Trip On"), "command": "1"},
]}
exports.heater_output_mode = function() { return [
{"name": l100n.localize_string("Relay"), "command": "0"},
{"name": l100n.localize_string("Soft Start"), "command": "1"},
{"name": l100n.localize_string("Average Current Limit"), "command": "2"}
]}
exports.heater_output_mode_rmo = function() { return [
{"name": l100n.localize_string("Relay"), "command": "0"},
{"name": l100n.localize_string("Soft Start"), "command": "1"},
]}
exports.alarm_trip_present = function() { return [
{"new_value": l100n.localize_string("Absent"), "raw_value": "0"},
{"new_value": l100n.localize_string("Present"), "raw_value": "1"},
]}
exports.do_channel_status = function() { return [
{"new_value": l100n.localize_string("DO_CH_STATUS_Off"), "raw_value": "0"},
{"new_value": l100n.localize_string("DO_CH_STATUS_WaitCool"), "raw_value": "1"},
{"new_value": l100n.localize_string("DO_CH_STATUS_SoftStart"), "raw_value": "2"},
{"new_value": l100n.localize_string("DO_CH_STATUS_TransitionProcess"), "raw_value": "3"},
{"new_value": l100n.localize_string("DO_CH_STATUS_On"), "raw_value": "4"},
{"new_value": l100n.localize_string("DO_CH_STATUS_CurrentLimiting"), "raw_value": "5"},
{"new_value": l100n.localize_string("DO_CH_STATUS_OverCurrent"), "raw_value": "6"},
{"new_value": l100n.localize_string("DO_CH_STATUS_Overheat"), "raw_value": "7"},
]}
exports.no_nc = function() { return [
{"new_value": l100n.localize_string("NO"), "raw_value": "0"},
{"new_value": l100n.localize_string("NC"), "raw_value": "1"},
]}
exports.leakage_current_mode = function() { return [
{"new_value": `63 ${l100n.localize_string("mA")}`, "raw_value": "0"},
{"new_value": `${(0.1).toLocaleString(get_cookie_locale())} ${l100n.localize_string("mA")}`, "raw_value": "128"},
{"new_value": l100n.localize_string("error_status"), "raw_value": "default"},
]}
exports.ai_status = function() { return [
{"new_value": l100n.localize_string("Norm"), "raw_value": "0"},
{"new_value": l100n.localize_string("error_status"), "raw_value": "default"},
]}
exports.lines_mode = function() { return [
{"name": l100n.localize_string("three single-phase"), "command": "0"},
{"name": l100n.localize_string("three-phase (master L1)"), "command": "1"},
]}
exports.ota_firmware_info = function() { return [
{"new_value": l100n.localize_string("Factory Firmware"), "raw_value": "0"},
{"new_value": l100n.localize_string("Firmware 1"), "raw_value": "1"},
{"new_value": l100n.localize_string("Firmware 2"), "raw_value": "2"},
]}
exports.ota_firmware_command = function() { return [
{"name": l100n.localize_string("Factory Firmware"), "command": "0"},
{"name": l100n.localize_string("Firmware 1"), "command": "1"},
{"name": l100n.localize_string("Firmware 2"), "command": "2"},
]}
exports.ota_update_firmware = function() { return [
{"name": l100n.localize_string("Update Firmware 1"), "command": "0x00070000"},
{"name": l100n.localize_string("Update Firmware 2"), "command": "0x00080000"},
]}
exports.value_int16 = function() { return [
{"new_value": "TempSens Fault(20000)", "raw_value": "20000"},
{"new_value": "TempSens Fault(10000)", "raw_value": "10000"},
{"new_value": "TempSens Fault(10010)", "raw_value": "10010"},
]}
exports.wet_dry_values = function() { return [
	{"name": l100n.localize_string("dry value"), "command": "0"},
	{"name": l100n.localize_string("wet value"), "command": "1"}
]}
exports.one_wire_commands = function() { return [
	{"name": "", "command": "0"},
	{"name": l100n.localize_string("ext_scan_button"), "command": "0x6e616353"}
]}
exports.rstp_port_status = function() { return [
	{"new_value": l100n.localize_string("Unknown"), "raw_value": "0"},
	{"new_value": l100n.localize_string("Disabled"), "raw_value": "5"},
	{"new_value": l100n.localize_string("Root"), "raw_value": "6"},
	{"new_value": l100n.localize_string("Designated"), "raw_value": "7"},
	{"new_value": l100n.localize_string("Alternate"), "raw_value": "8"},
	{"new_value": l100n.localize_string("Backup"), "raw_value": "9"},
	{"new_value": l100n.localize_string("Master"), "raw_value": "10"},
]}
exports.true_false_auto = function() { return [
	{"name": l100n.localize_string("True"), "command": "1"},
	{"name": l100n.localize_string("False"), "command": "2"},
	{"name": l100n.localize_string("Auto"), "command": "3"},
]}
exports.off_on_auto = function() { return [
	{"name": l100n.localize_string("Off"), "command": "0"},
	{"name": l100n.localize_string("On"), "command": "1"},
	{"name": l100n.localize_string("Auto"), "command": "2"},
]}



})(this.templates_commands = {});
